// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SpringAppDiscovery.Mocking
{
    /// <summary> A class to add extension methods to SubscriptionResource. </summary>
    public partial class MockableSpringAppDiscoverySubscriptionResource : ArmResource
    {
        private ClientDiagnostics _springBootSitespringbootsitesClientDiagnostics;
        private SpringbootsitesRestOperations _springBootSitespringbootsitesRestClient;
        private ClientDiagnostics _springBootServerspringbootserversClientDiagnostics;
        private SpringbootserversRestOperations _springBootServerspringbootserversRestClient;
        private ClientDiagnostics _springBootAppspringbootappsClientDiagnostics;
        private SpringbootappsRestOperations _springBootAppspringbootappsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoverySubscriptionResource"/> class for mocking. </summary>
        protected MockableSpringAppDiscoverySubscriptionResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoverySubscriptionResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSpringAppDiscoverySubscriptionResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics SpringBootSitespringbootsitesClientDiagnostics => _springBootSitespringbootsitesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootSiteResource.ResourceType.Namespace, Diagnostics);
        private SpringbootsitesRestOperations SpringBootSitespringbootsitesRestClient => _springBootSitespringbootsitesRestClient ??= new SpringbootsitesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SpringBootSiteResource.ResourceType));
        private ClientDiagnostics SpringBootServerspringbootserversClientDiagnostics => _springBootServerspringbootserversClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootServerResource.ResourceType.Namespace, Diagnostics);
        private SpringbootserversRestOperations SpringBootServerspringbootserversRestClient => _springBootServerspringbootserversRestClient ??= new SpringbootserversRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SpringBootServerResource.ResourceType));
        private ClientDiagnostics SpringBootAppspringbootappsClientDiagnostics => _springBootAppspringbootappsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.SpringAppDiscovery", SpringBootAppResource.ResourceType.Namespace, Diagnostics);
        private SpringbootappsRestOperations SpringBootAppspringbootappsRestClient => _springBootAppspringbootappsRestClient ??= new SpringbootappsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(SpringBootAppResource.ResourceType));

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// List springbootsites resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootSiteResource> GetSpringBootSitesAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootSitespringbootsitesRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootSitespringbootsitesRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteResource(Client, SpringBootSiteData.DeserializeSpringBootSiteData(e)), SpringBootSitespringbootsitesClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootSites", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootsites resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SpringBootSiteResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootSiteResource> GetSpringBootSites(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootSitespringbootsitesRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootSitespringbootsitesRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootSiteResource(Client, SpringBootSiteData.DeserializeSpringBootSiteData(e)), SpringBootSitespringbootsitesClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootSites", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootservers resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootservers_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteName"/> is null. </exception>
        /// <returns> An async collection of <see cref="SpringBootServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootServerResource> GetSpringBootServersAsync(string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteName, nameof(siteName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootServerspringbootserversRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId, siteName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootServerspringbootserversRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId, siteName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootServerResource(Client, SpringBootServerData.DeserializeSpringBootServerData(e)), SpringBootServerspringbootserversClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootServers", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootservers resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootservers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootservers_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootServerResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteName"/> is null. </exception>
        /// <returns> A collection of <see cref="SpringBootServerResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootServerResource> GetSpringBootServers(string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteName, nameof(siteName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootServerspringbootserversRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId, siteName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootServerspringbootserversRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId, siteName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootServerResource(Client, SpringBootServerData.DeserializeSpringBootServerData(e)), SpringBootServerspringbootserversClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootServers", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootapps resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteName"/> is null. </exception>
        /// <returns> An async collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SpringBootAppResource> GetSpringBootAppsAsync(string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteName, nameof(siteName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootAppspringbootappsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId, siteName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootAppspringbootappsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId, siteName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SpringBootAppResource(Client, SpringBootAppData.DeserializeSpringBootAppData(e)), SpringBootAppspringbootappsClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootApps", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List springbootapps resource by subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{siteName}/springbootapps</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootapps_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootAppResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="siteName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="siteName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="siteName"/> is null. </exception>
        /// <returns> A collection of <see cref="SpringBootAppResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SpringBootAppResource> GetSpringBootApps(string siteName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(siteName, nameof(siteName));

            HttpMessage FirstPageRequest(int? pageSizeHint) => SpringBootAppspringbootappsRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId, siteName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => SpringBootAppspringbootappsRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId, siteName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SpringBootAppResource(Client, SpringBootAppData.DeserializeSpringBootAppData(e)), SpringBootAppspringbootappsClientDiagnostics, Pipeline, "MockableSpringAppDiscoverySubscriptionResource.GetSpringBootApps", "value", "nextLink", cancellationToken);
        }
    }
}
