// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableSpringAppDiscoveryResourceGroupResource : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoveryResourceGroupResource"/> class for mocking. </summary>
        protected MockableSpringAppDiscoveryResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoveryResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSpringAppDiscoveryResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of SpringBootSiteResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of SpringBootSiteResources and their operations over a SpringBootSiteResource. </returns>
        public virtual SpringBootSiteCollection GetSpringBootSites()
        {
            return GetCachedClient(client => new SpringBootSiteCollection(client, Id));
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SpringBootSiteResource>> GetSpringBootSiteAsync(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            return await GetSpringBootSites().GetAsync(springbootsitesName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a springbootsites resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>springbootsites_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SpringBootSiteResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="springbootsitesName"> The springbootsites name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="springbootsitesName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="springbootsitesName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SpringBootSiteResource> GetSpringBootSite(string springbootsitesName, CancellationToken cancellationToken = default)
        {
            return GetSpringBootSites().Get(springbootsitesName, cancellationToken);
        }
    }
}
