// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.SpringAppDiscovery.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSpringAppDiscoveryArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoveryArmClient"/> class for mocking. </summary>
        protected MockableSpringAppDiscoveryArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSpringAppDiscoveryArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSpringAppDiscoveryArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSpringAppDiscoveryArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SpringBootSiteResource"/> object. </returns>
        public virtual SpringBootSiteResource GetSpringBootSiteResource(ResourceIdentifier id)
        {
            SpringBootSiteResource.ValidateResourceId(id);
            return new SpringBootSiteResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootServerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootServerResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootServerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SpringBootServerResource"/> object. </returns>
        public virtual SpringBootServerResource GetSpringBootServerResource(ResourceIdentifier id)
        {
            SpringBootServerResource.ValidateResourceId(id);
            return new SpringBootServerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootAppResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootAppResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootAppResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SpringBootAppResource"/> object. </returns>
        public virtual SpringBootAppResource GetSpringBootAppResource(ResourceIdentifier id)
        {
            SpringBootAppResource.ValidateResourceId(id);
            return new SpringBootAppResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteSummaryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteSummaryResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteSummaryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SpringBootSiteSummaryResource"/> object. </returns>
        public virtual SpringBootSiteSummaryResource GetSpringBootSiteSummaryResource(ResourceIdentifier id)
        {
            SpringBootSiteSummaryResource.ValidateResourceId(id);
            return new SpringBootSiteSummaryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SpringBootSiteErrorSummaryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SpringBootSiteErrorSummaryResource.CreateResourceIdentifier" /> to create a <see cref="SpringBootSiteErrorSummaryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SpringBootSiteErrorSummaryResource"/> object. </returns>
        public virtual SpringBootSiteErrorSummaryResource GetSpringBootSiteErrorSummaryResource(ResourceIdentifier id)
        {
            SpringBootSiteErrorSummaryResource.ValidateResourceId(id);
            return new SpringBootSiteErrorSummaryResource(Client, id);
        }
    }
}
