// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SpringAppDiscovery.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSpringAppDiscoveryModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="SpringAppDiscovery.SpringBootSiteData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties">
        /// The springbootsites resource definition.
        /// Serialized Name: SpringbootsitesModel.properties
        /// </param>
        /// <param name="extendedLocation">
        /// The extended location definition.
        /// Serialized Name: SpringbootsitesModel.extendedLocation
        /// </param>
        /// <returns> A new <see cref="SpringAppDiscovery.SpringBootSiteData"/> instance for mocking. </returns>
        public static SpringBootSiteData SpringBootSiteData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, SpringBootSiteProperties properties = null, SpringBootSiteModelExtendedLocation extendedLocation = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootSiteData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                extendedLocation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SpringBootSitePatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties">
        /// The springbootsites resource definition.
        /// Serialized Name: SpringbootsitesPatch.properties
        /// </param>
        /// <returns> A new <see cref="Models.SpringBootSitePatch"/> instance for mocking. </returns>
        public static SpringBootSitePatch SpringBootSitePatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, SpringBootSiteProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootSitePatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SpringAppDiscovery.SpringBootServerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: SpringbootserversModel.tags
        /// </param>
        /// <param name="properties">
        /// The springbootservers resource definition.
        /// Serialized Name: SpringbootserversModel.properties
        /// </param>
        /// <returns> A new <see cref="SpringAppDiscovery.SpringBootServerData"/> instance for mocking. </returns>
        public static SpringBootServerData SpringBootServerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, SpringBootServerProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootServerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SpringBootServerPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: SpringbootserversPatch.tags
        /// </param>
        /// <param name="properties">
        /// The springbootsites resource definition.
        /// Serialized Name: SpringbootserversPatch.properties
        /// </param>
        /// <returns> A new <see cref="Models.SpringBootServerPatch"/> instance for mocking. </returns>
        public static SpringBootServerPatch SpringBootServerPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, SpringBootServerProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootServerPatch(
                id,
                name,
                resourceType,
                systemData,
                tags,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SpringAppDiscovery.SpringBootAppData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// The springbootapps resource definition.
        /// Serialized Name: SpringbootappsModel.properties
        /// </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: SpringbootappsModel.tags
        /// </param>
        /// <returns> A new <see cref="SpringAppDiscovery.SpringBootAppData"/> instance for mocking. </returns>
        public static SpringBootAppData SpringBootAppData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SpringBootAppProperties properties = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootAppData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SpringBootAppPatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// The springbootapps resource definition.
        /// Serialized Name: SpringbootappsPatch.properties
        /// </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: SpringbootappsPatch.tags
        /// </param>
        /// <returns> A new <see cref="Models.SpringBootAppPatch"/> instance for mocking. </returns>
        public static SpringBootAppPatch SpringBootAppPatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SpringBootAppProperties properties = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootAppPatch(
                id,
                name,
                resourceType,
                systemData,
                properties,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SpringAppDiscovery.SpringBootSiteSummaryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Resource properties.
        /// Serialized Name: Summary.properties
        /// </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: Summary.tags
        /// </param>
        /// <returns> A new <see cref="SpringAppDiscovery.SpringBootSiteSummaryData"/> instance for mocking. </returns>
        public static SpringBootSiteSummaryData SpringBootSiteSummaryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SpringBootSiteSummariesProperties properties = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootSiteSummaryData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SpringAppDiscovery.SpringBootSiteErrorSummaryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Resource properties.
        /// Serialized Name: ErrorSummary.properties
        /// </param>
        /// <param name="tags">
        /// Resource tags
        /// Serialized Name: ErrorSummary.tags
        /// </param>
        /// <returns> A new <see cref="SpringAppDiscovery.SpringBootSiteErrorSummaryData"/> instance for mocking. </returns>
        public static SpringBootSiteErrorSummaryData SpringBootSiteErrorSummaryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, SpringBootSiteErrorSummariesProperties properties = null, IDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SpringBootSiteErrorSummaryData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                tags,
                serializedAdditionalRawData: null);
        }
    }
}
