// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SpringAppDiscovery.Models;

namespace Azure.ResourceManager.SpringAppDiscovery.Samples
{
    public partial class Sample_SpringBootAppResource
    {
        // springbootapps_Get_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SpringbootappsGetMaximumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_Get_MaximumSet_Gen.json
            // this example is just showing the usage of "springbootapps_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpringBootAppResource created on azure
            // for more information of creating SpringBootAppResource, please refer to the document of SpringBootAppResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            string resourceGroupName = "rgspringbootapps";
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            string springbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf";
            ResourceIdentifier springBootAppResourceId = SpringBootAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, siteName, springbootappsName);
            SpringBootAppResource springBootApp = client.GetSpringBootAppResource(springBootAppResourceId);

            // invoke the operation
            SpringBootAppResource result = await springBootApp.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpringBootAppData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // springbootapps_Get_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SpringbootappsGetMinimumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_Get_MinimumSet_Gen.json
            // this example is just showing the usage of "springbootapps_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpringBootAppResource created on azure
            // for more information of creating SpringBootAppResource, please refer to the document of SpringBootAppResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            string resourceGroupName = "rgspringbootapps";
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            string springbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf";
            ResourceIdentifier springBootAppResourceId = SpringBootAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, siteName, springbootappsName);
            SpringBootAppResource springBootApp = client.GetSpringBootAppResource(springBootAppResourceId);

            // invoke the operation
            SpringBootAppResource result = await springBootApp.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpringBootAppData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // springbootapps_Update_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SpringbootappsUpdateMaximumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_Update_MaximumSet_Gen.json
            // this example is just showing the usage of "springbootapps_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpringBootAppResource created on azure
            // for more information of creating SpringBootAppResource, please refer to the document of SpringBootAppResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            string resourceGroupName = "rgspringbootapps";
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            string springbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf";
            ResourceIdentifier springBootAppResourceId = SpringBootAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, siteName, springbootappsName);
            SpringBootAppResource springBootApp = client.GetSpringBootAppResource(springBootAppResourceId);

            // invoke the operation
            SpringBootAppPatch patch = new SpringBootAppPatch();
            ArmOperation<SpringBootAppResource> lro = await springBootApp.UpdateAsync(WaitUntil.Completed, patch);
            SpringBootAppResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpringBootAppData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // springbootapps_Update_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SpringbootappsUpdateMinimumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_Update_MinimumSet_Gen.json
            // this example is just showing the usage of "springbootapps_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SpringBootAppResource created on azure
            // for more information of creating SpringBootAppResource, please refer to the document of SpringBootAppResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            string resourceGroupName = "rgspringbootapps";
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            string springbootappsName = "ofjeesoahqtnovlbuvflyknpbhcpeqqhekntvqxyemuwbcqnuxjgfhsf";
            ResourceIdentifier springBootAppResourceId = SpringBootAppResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, siteName, springbootappsName);
            SpringBootAppResource springBootApp = client.GetSpringBootAppResource(springBootAppResourceId);

            // invoke the operation
            SpringBootAppPatch patch = new SpringBootAppPatch();
            ArmOperation<SpringBootAppResource> lro = await springBootApp.UpdateAsync(WaitUntil.Completed, patch);
            SpringBootAppResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SpringBootAppData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // springbootapps_ListBySubscription_MaximumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSpringBootApps_SpringbootappsListBySubscriptionMaximumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_ListBySubscription_MaximumSet_Gen.json
            // this example is just showing the usage of "springbootapps_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            await foreach (SpringBootAppResource item in subscriptionResource.GetSpringBootAppsAsync(siteName))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SpringBootAppData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // springbootapps_ListBySubscription_MinimumSet_Gen
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSpringBootApps_SpringbootappsListBySubscriptionMinimumSetGen()
        {
            // Generated from example definition: specification/offazurespringboot/resource-manager/Microsoft.OffAzureSpringBoot/preview/2023-01-01-preview/examples/springbootapps_ListBySubscription_MinimumSet_Gen.json
            // this example is just showing the usage of "springbootapps_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "jnetwlorzmxpxmcucorv";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            string siteName = "pdfosfhtemfsaglvwjdyqlyeipucrd";
            await foreach (SpringBootAppResource item in subscriptionResource.GetSpringBootAppsAsync(siteName))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SpringBootAppData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
