// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sphere.Models;

namespace Azure.ResourceManager.Sphere
{
    /// <summary>
    /// A class representing the SphereDevice data model.
    /// An device resource belonging to a device group resource.
    /// </summary>
    public partial class SphereDeviceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SphereDeviceData"/>. </summary>
        public SphereDeviceData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SphereDeviceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="deviceId"> Device ID. </param>
        /// <param name="chipSku"> SKU of the chip. </param>
        /// <param name="lastAvailableOSVersion"> OS version available for installation when update requested. </param>
        /// <param name="lastInstalledOSVersion"> OS version running on device when update requested. </param>
        /// <param name="lastOSUpdateUtc"> Time when update requested and new OS version available. </param>
        /// <param name="lastUpdateRequestUtc"> Time when update was last requested. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SphereDeviceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string deviceId, string chipSku, string lastAvailableOSVersion, string lastInstalledOSVersion, DateTimeOffset? lastOSUpdateUtc, DateTimeOffset? lastUpdateRequestUtc, SphereProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DeviceId = deviceId;
            ChipSku = chipSku;
            LastAvailableOSVersion = lastAvailableOSVersion;
            LastInstalledOSVersion = lastInstalledOSVersion;
            LastOSUpdateUtc = lastOSUpdateUtc;
            LastUpdateRequestUtc = lastUpdateRequestUtc;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Device ID. </summary>
        public string DeviceId { get; set; }
        /// <summary> SKU of the chip. </summary>
        public string ChipSku { get; }
        /// <summary> OS version available for installation when update requested. </summary>
        public string LastAvailableOSVersion { get; }
        /// <summary> OS version running on device when update requested. </summary>
        public string LastInstalledOSVersion { get; }
        /// <summary> Time when update requested and new OS version available. </summary>
        public DateTimeOffset? LastOSUpdateUtc { get; }
        /// <summary> Time when update was last requested. </summary>
        public DateTimeOffset? LastUpdateRequestUtc { get; }
        /// <summary> The status of the last operation. </summary>
        public SphereProvisioningState? ProvisioningState { get; }
    }
}
