// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Sphere
{
    /// <summary>
    /// A class representing a collection of <see cref="SphereDeviceResource"/> and their operations.
    /// Each <see cref="SphereDeviceResource"/> in the collection will belong to the same instance of <see cref="SphereDeviceGroupResource"/>.
    /// To get a <see cref="SphereDeviceCollection"/> instance call the GetSphereDevices method from an instance of <see cref="SphereDeviceGroupResource"/>.
    /// </summary>
    public partial class SphereDeviceCollection : ArmCollection, IEnumerable<SphereDeviceResource>, IAsyncEnumerable<SphereDeviceResource>
    {
        private readonly ClientDiagnostics _sphereDeviceDevicesClientDiagnostics;
        private readonly DevicesRestOperations _sphereDeviceDevicesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SphereDeviceCollection"/> class for mocking. </summary>
        protected SphereDeviceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SphereDeviceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SphereDeviceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sphereDeviceDevicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sphere", SphereDeviceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SphereDeviceResource.ResourceType, out string sphereDeviceDevicesApiVersion);
            _sphereDeviceDevicesRestClient = new DevicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sphereDeviceDevicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SphereDeviceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SphereDeviceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a Device. Use '.unassigned' or '.default' for the device group and product names to claim a device to the catalog only.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SphereDeviceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string deviceName, SphereDeviceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sphereDeviceDevicesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SphereArmOperation<SphereDeviceResource>(new SphereDeviceOperationSource(Client), _sphereDeviceDevicesClientDiagnostics, Pipeline, _sphereDeviceDevicesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a Device. Use '.unassigned' or '.default' for the device group and product names to claim a device to the catalog only.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="data"> Resource create parameters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SphereDeviceResource> CreateOrUpdate(WaitUntil waitUntil, string deviceName, SphereDeviceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sphereDeviceDevicesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, data, cancellationToken);
                var operation = new SphereArmOperation<SphereDeviceResource>(new SphereDeviceOperationSource(Client), _sphereDeviceDevicesClientDiagnostics, Pipeline, _sphereDeviceDevicesRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a Device. Use '.unassigned' or '.default' for the device group and product names when a device does not belong to a device group and product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual async Task<Response<SphereDeviceResource>> GetAsync(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.Get");
            scope.Start();
            try
            {
                var response = await _sphereDeviceDevicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SphereDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a Device. Use '.unassigned' or '.default' for the device group and product names when a device does not belong to a device group and product.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual Response<SphereDeviceResource> Get(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.Get");
            scope.Start();
            try
            {
                var response = _sphereDeviceDevicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SphereDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List Device resources by DeviceGroup. '.default' and '.unassigned' are system defined values and cannot be used for product or device group name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_ListByDeviceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SphereDeviceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SphereDeviceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sphereDeviceDevicesRestClient.CreateListByDeviceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sphereDeviceDevicesRestClient.CreateListByDeviceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SphereDeviceResource(Client, SphereDeviceData.DeserializeSphereDeviceData(e)), _sphereDeviceDevicesClientDiagnostics, Pipeline, "SphereDeviceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List Device resources by DeviceGroup. '.default' and '.unassigned' are system defined values and cannot be used for product or device group name.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_ListByDeviceGroup</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SphereDeviceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SphereDeviceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sphereDeviceDevicesRestClient.CreateListByDeviceGroupRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sphereDeviceDevicesRestClient.CreateListByDeviceGroupNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SphereDeviceResource(Client, SphereDeviceData.DeserializeSphereDeviceData(e)), _sphereDeviceDevicesClientDiagnostics, Pipeline, "SphereDeviceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sphereDeviceDevicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual Response<bool> Exists(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.Exists");
            scope.Start();
            try
            {
                var response = _sphereDeviceDevicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SphereDeviceResource>> GetIfExistsAsync(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sphereDeviceDevicesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SphereDeviceResource>(response.GetRawResponse());
                return Response.FromValue(new SphereDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Devices_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SphereDeviceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="deviceName"> Device name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="deviceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="deviceName"/> is null. </exception>
        public virtual NullableResponse<SphereDeviceResource> GetIfExists(string deviceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(deviceName, nameof(deviceName));

            using var scope = _sphereDeviceDevicesClientDiagnostics.CreateScope("SphereDeviceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sphereDeviceDevicesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, deviceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SphereDeviceResource>(response.GetRawResponse());
                return Response.FromValue(new SphereDeviceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SphereDeviceResource> IEnumerable<SphereDeviceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SphereDeviceResource> IAsyncEnumerable<SphereDeviceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
