// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Update policy values. </summary>
    public readonly partial struct SphereUpdatePolicy : IEquatable<SphereUpdatePolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SphereUpdatePolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SphereUpdatePolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UpdateAllValue = "UpdateAll";
        private const string No3RdPartyAppUpdatesValue = "No3rdPartyAppUpdates";

        /// <summary> Update all policy. </summary>
        public static SphereUpdatePolicy UpdateAll { get; } = new SphereUpdatePolicy(UpdateAllValue);
        /// <summary> No update for 3rd party app policy. </summary>
        public static SphereUpdatePolicy No3RdPartyAppUpdates { get; } = new SphereUpdatePolicy(No3RdPartyAppUpdatesValue);
        /// <summary> Determines if two <see cref="SphereUpdatePolicy"/> values are the same. </summary>
        public static bool operator ==(SphereUpdatePolicy left, SphereUpdatePolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SphereUpdatePolicy"/> values are not the same. </summary>
        public static bool operator !=(SphereUpdatePolicy left, SphereUpdatePolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SphereUpdatePolicy"/>. </summary>
        public static implicit operator SphereUpdatePolicy(string value) => new SphereUpdatePolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SphereUpdatePolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SphereUpdatePolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
