// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Provisioning state of resource. </summary>
    public readonly partial struct SphereProvisioningState : IEquatable<SphereProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SphereProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SphereProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";

        /// <summary> Resource has been created. </summary>
        public static SphereProvisioningState Succeeded { get; } = new SphereProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static SphereProvisioningState Failed { get; } = new SphereProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static SphereProvisioningState Canceled { get; } = new SphereProvisioningState(CanceledValue);
        /// <summary> The resource is being provisioned. </summary>
        public static SphereProvisioningState Provisioning { get; } = new SphereProvisioningState(ProvisioningValue);
        /// <summary> The resource is being updated. </summary>
        public static SphereProvisioningState Updating { get; } = new SphereProvisioningState(UpdatingValue);
        /// <summary> The resource is being deleted. </summary>
        public static SphereProvisioningState Deleting { get; } = new SphereProvisioningState(DeletingValue);
        /// <summary> The resource create request has been accepted. </summary>
        public static SphereProvisioningState Accepted { get; } = new SphereProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="SphereProvisioningState"/> values are the same. </summary>
        public static bool operator ==(SphereProvisioningState left, SphereProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SphereProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(SphereProvisioningState left, SphereProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SphereProvisioningState"/>. </summary>
        public static implicit operator SphereProvisioningState(string value) => new SphereProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SphereProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SphereProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
