// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sphere.Models
{
    public partial class SphereDeviceInsight : IUtf8JsonSerializable, IJsonModel<SphereDeviceInsight>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SphereDeviceInsight>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SphereDeviceInsight>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SphereDeviceInsight>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SphereDeviceInsight)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("deviceId"u8);
            writer.WriteStringValue(DeviceId);
            writer.WritePropertyName("description"u8);
            writer.WriteStringValue(Description);
            writer.WritePropertyName("startTimestampUtc"u8);
            writer.WriteStringValue(StartTimestampUtc, "O");
            writer.WritePropertyName("endTimestampUtc"u8);
            writer.WriteStringValue(EndTimestampUtc, "O");
            writer.WritePropertyName("eventCategory"u8);
            writer.WriteStringValue(EventCategory);
            writer.WritePropertyName("eventClass"u8);
            writer.WriteStringValue(EventClass);
            writer.WritePropertyName("eventType"u8);
            writer.WriteStringValue(EventType);
            writer.WritePropertyName("eventCount"u8);
            writer.WriteNumberValue(EventCount);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SphereDeviceInsight IJsonModel<SphereDeviceInsight>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SphereDeviceInsight>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SphereDeviceInsight)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSphereDeviceInsight(document.RootElement, options);
        }

        internal static SphereDeviceInsight DeserializeSphereDeviceInsight(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deviceId = default;
            string description = default;
            DateTimeOffset startTimestampUtc = default;
            DateTimeOffset endTimestampUtc = default;
            string eventCategory = default;
            string eventClass = default;
            string eventType = default;
            int eventCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceId"u8))
                {
                    deviceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTimestampUtc"u8))
                {
                    startTimestampUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTimestampUtc"u8))
                {
                    endTimestampUtc = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("eventCategory"u8))
                {
                    eventCategory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventClass"u8))
                {
                    eventClass = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventType"u8))
                {
                    eventType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventCount"u8))
                {
                    eventCount = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SphereDeviceInsight(
                deviceId,
                description,
                startTimestampUtc,
                endTimestampUtc,
                eventCategory,
                eventClass,
                eventType,
                eventCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SphereDeviceInsight>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SphereDeviceInsight>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SphereDeviceInsight)} does not support writing '{options.Format}' format.");
            }
        }

        SphereDeviceInsight IPersistableModel<SphereDeviceInsight>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SphereDeviceInsight>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSphereDeviceInsight(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SphereDeviceInsight)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SphereDeviceInsight>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
