// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Certificate status values. </summary>
    public readonly partial struct SphereCertificateStatus : IEquatable<SphereCertificateStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SphereCertificateStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SphereCertificateStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string InactiveValue = "Inactive";
        private const string ExpiredValue = "Expired";
        private const string RevokedValue = "Revoked";

        /// <summary> Certificate is active. </summary>
        public static SphereCertificateStatus Active { get; } = new SphereCertificateStatus(ActiveValue);
        /// <summary> Certificate is inactive. </summary>
        public static SphereCertificateStatus Inactive { get; } = new SphereCertificateStatus(InactiveValue);
        /// <summary> Certificate has expired. </summary>
        public static SphereCertificateStatus Expired { get; } = new SphereCertificateStatus(ExpiredValue);
        /// <summary> Certificate has been revoked. </summary>
        public static SphereCertificateStatus Revoked { get; } = new SphereCertificateStatus(RevokedValue);
        /// <summary> Determines if two <see cref="SphereCertificateStatus"/> values are the same. </summary>
        public static bool operator ==(SphereCertificateStatus left, SphereCertificateStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SphereCertificateStatus"/> values are not the same. </summary>
        public static bool operator !=(SphereCertificateStatus left, SphereCertificateStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SphereCertificateStatus"/>. </summary>
        public static implicit operator SphereCertificateStatus(string value) => new SphereCertificateStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SphereCertificateStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SphereCertificateStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
