// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Capability image type. </summary>
    public readonly partial struct SphereCapabilityType : IEquatable<SphereCapabilityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SphereCapabilityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SphereCapabilityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ApplicationDevelopmentValue = "ApplicationDevelopment";
        private const string FieldServicingValue = "FieldServicing";

        /// <summary> Application development capability. </summary>
        public static SphereCapabilityType ApplicationDevelopment { get; } = new SphereCapabilityType(ApplicationDevelopmentValue);
        /// <summary> Field servicing capability. </summary>
        public static SphereCapabilityType FieldServicing { get; } = new SphereCapabilityType(FieldServicingValue);
        /// <summary> Determines if two <see cref="SphereCapabilityType"/> values are the same. </summary>
        public static bool operator ==(SphereCapabilityType left, SphereCapabilityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SphereCapabilityType"/> values are not the same. </summary>
        public static bool operator !=(SphereCapabilityType left, SphereCapabilityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SphereCapabilityType"/>. </summary>
        public static implicit operator SphereCapabilityType(string value) => new SphereCapabilityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SphereCapabilityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SphereCapabilityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
