// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Regional data boundary values. </summary>
    public readonly partial struct RegionalDataBoundary : IEquatable<RegionalDataBoundary>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RegionalDataBoundary"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RegionalDataBoundary(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string EUValue = "EU";

        /// <summary> No data boundary. </summary>
        public static RegionalDataBoundary None { get; } = new RegionalDataBoundary(NoneValue);
        /// <summary> EU data boundary. </summary>
        public static RegionalDataBoundary EU { get; } = new RegionalDataBoundary(EUValue);
        /// <summary> Determines if two <see cref="RegionalDataBoundary"/> values are the same. </summary>
        public static bool operator ==(RegionalDataBoundary left, RegionalDataBoundary right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RegionalDataBoundary"/> values are not the same. </summary>
        public static bool operator !=(RegionalDataBoundary left, RegionalDataBoundary right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RegionalDataBoundary"/>. </summary>
        public static implicit operator RegionalDataBoundary(string value) => new RegionalDataBoundary(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RegionalDataBoundary other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RegionalDataBoundary other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
