// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Request for the proof of possession nonce. </summary>
    public partial class ProofOfPossessionNonceContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProofOfPossessionNonceContent"/>. </summary>
        /// <param name="proofOfPossessionNonce"> The proof of possession nonce. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="proofOfPossessionNonce"/> is null. </exception>
        public ProofOfPossessionNonceContent(string proofOfPossessionNonce)
        {
            Argument.AssertNotNull(proofOfPossessionNonce, nameof(proofOfPossessionNonce));

            ProofOfPossessionNonce = proofOfPossessionNonce;
        }

        /// <summary> Initializes a new instance of <see cref="ProofOfPossessionNonceContent"/>. </summary>
        /// <param name="proofOfPossessionNonce"> The proof of possession nonce. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProofOfPossessionNonceContent(string proofOfPossessionNonce, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProofOfPossessionNonce = proofOfPossessionNonce;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ProofOfPossessionNonceContent"/> for deserialization. </summary>
        internal ProofOfPossessionNonceContent()
        {
        }

        /// <summary> The proof of possession nonce. </summary>
        public string ProofOfPossessionNonce { get; }
    }
}
