// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Sphere.Models
{
    public partial class GenerateCapabilityImageContent : IUtf8JsonSerializable, IJsonModel<GenerateCapabilityImageContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GenerateCapabilityImageContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GenerateCapabilityImageContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateCapabilityImageContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GenerateCapabilityImageContent)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("capabilities"u8);
            writer.WriteStartArray();
            foreach (var item in Capabilities)
            {
                writer.WriteStringValue(item.ToString());
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GenerateCapabilityImageContent IJsonModel<GenerateCapabilityImageContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateCapabilityImageContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GenerateCapabilityImageContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGenerateCapabilityImageContent(document.RootElement, options);
        }

        internal static GenerateCapabilityImageContent DeserializeGenerateCapabilityImageContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<SphereCapabilityType> capabilities = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("capabilities"u8))
                {
                    List<SphereCapabilityType> array = new List<SphereCapabilityType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new SphereCapabilityType(item.GetString()));
                    }
                    capabilities = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GenerateCapabilityImageContent(capabilities, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GenerateCapabilityImageContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateCapabilityImageContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GenerateCapabilityImageContent)} does not support writing '{options.Format}' format.");
            }
        }

        GenerateCapabilityImageContent IPersistableModel<GenerateCapabilityImageContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GenerateCapabilityImageContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGenerateCapabilityImageContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GenerateCapabilityImageContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GenerateCapabilityImageContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
