// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sphere
{
    internal class SphereProductOperationSource : IOperationSource<SphereProductResource>
    {
        private readonly ArmClient _client;

        internal SphereProductOperationSource(ArmClient client)
        {
            _client = client;
        }

        SphereProductResource IOperationSource<SphereProductResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SphereProductData.DeserializeSphereProductData(document.RootElement);
            return new SphereProductResource(_client, data);
        }

        async ValueTask<SphereProductResource> IOperationSource<SphereProductResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SphereProductData.DeserializeSphereProductData(document.RootElement);
            return new SphereProductResource(_client, data);
        }
    }
}
