// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sphere
{
    internal class SphereDeviceOperationSource : IOperationSource<SphereDeviceResource>
    {
        private readonly ArmClient _client;

        internal SphereDeviceOperationSource(ArmClient client)
        {
            _client = client;
        }

        SphereDeviceResource IOperationSource<SphereDeviceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SphereDeviceData.DeserializeSphereDeviceData(document.RootElement);
            return new SphereDeviceResource(_client, data);
        }

        async ValueTask<SphereDeviceResource> IOperationSource<SphereDeviceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SphereDeviceData.DeserializeSphereDeviceData(document.RootElement);
            return new SphereDeviceResource(_client, data);
        }
    }
}
