// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sphere
{
    internal class SphereDeviceGroupOperationSource : IOperationSource<SphereDeviceGroupResource>
    {
        private readonly ArmClient _client;

        internal SphereDeviceGroupOperationSource(ArmClient client)
        {
            _client = client;
        }

        SphereDeviceGroupResource IOperationSource<SphereDeviceGroupResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SphereDeviceGroupData.DeserializeSphereDeviceGroupData(document.RootElement);
            return new SphereDeviceGroupResource(_client, data);
        }

        async ValueTask<SphereDeviceGroupResource> IOperationSource<SphereDeviceGroupResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SphereDeviceGroupData.DeserializeSphereDeviceGroupData(document.RootElement);
            return new SphereDeviceGroupResource(_client, data);
        }
    }
}
