// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sphere
{
    internal class SphereDeploymentOperationSource : IOperationSource<SphereDeploymentResource>
    {
        private readonly ArmClient _client;

        internal SphereDeploymentOperationSource(ArmClient client)
        {
            _client = client;
        }

        SphereDeploymentResource IOperationSource<SphereDeploymentResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SphereDeploymentData.DeserializeSphereDeploymentData(document.RootElement);
            return new SphereDeploymentResource(_client, data);
        }

        async ValueTask<SphereDeploymentResource> IOperationSource<SphereDeploymentResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SphereDeploymentData.DeserializeSphereDeploymentData(document.RootElement);
            return new SphereDeploymentResource(_client, data);
        }
    }
}
