// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Sphere
{
    internal class SphereCatalogOperationSource : IOperationSource<SphereCatalogResource>
    {
        private readonly ArmClient _client;

        internal SphereCatalogOperationSource(ArmClient client)
        {
            _client = client;
        }

        SphereCatalogResource IOperationSource<SphereCatalogResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SphereCatalogData.DeserializeSphereCatalogData(document.RootElement);
            return new SphereCatalogResource(_client, data);
        }

        async ValueTask<SphereCatalogResource> IOperationSource<SphereCatalogResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SphereCatalogData.DeserializeSphereCatalogData(document.RootElement);
            return new SphereCatalogResource(_client, data);
        }
    }
}
