// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Sphere.Models;

namespace Azure.ResourceManager.Sphere
{
    internal class SignedCapabilityImageResponseOperationSource : IOperationSource<SignedCapabilityImageResponse>
    {
        SignedCapabilityImageResponse IOperationSource<SignedCapabilityImageResponse>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return SignedCapabilityImageResponse.DeserializeSignedCapabilityImageResponse(document.RootElement);
        }

        async ValueTask<SignedCapabilityImageResponse> IOperationSource<SignedCapabilityImageResponse>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return SignedCapabilityImageResponse.DeserializeSignedCapabilityImageResponse(document.RootElement);
        }
    }
}
