// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Sphere.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSphereModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Sphere.SphereCatalogData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="tenantId"> The Azure Sphere tenant ID associated with the catalog. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereCatalogData"/> instance for mocking. </returns>
        public static SphereCatalogData SphereCatalogData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, Guid? tenantId = null, SphereProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SphereCatalogData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                tenantId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereCertificateData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="certificate"> The certificate as a UTF-8 encoded base 64 string. </param>
        /// <param name="status"> The certificate status. </param>
        /// <param name="subject"> The certificate subject. </param>
        /// <param name="thumbprint"> The certificate thumbprint. </param>
        /// <param name="expiryUtc"> The certificate expiry date. </param>
        /// <param name="notBeforeUtc"> The certificate not before date. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereCertificateData"/> instance for mocking. </returns>
        public static SphereCertificateData SphereCertificateData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string certificate = null, SphereCertificateStatus? status = null, string subject = null, string thumbprint = null, DateTimeOffset? expiryUtc = null, DateTimeOffset? notBeforeUtc = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereCertificateData(
                id,
                name,
                resourceType,
                systemData,
                certificate,
                status,
                subject,
                thumbprint,
                expiryUtc,
                notBeforeUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SphereCertificateProperties"/>. </summary>
        /// <param name="certificate"> The certificate as a UTF-8 encoded base 64 string. </param>
        /// <param name="status"> The certificate status. </param>
        /// <param name="subject"> The certificate subject. </param>
        /// <param name="thumbprint"> The certificate thumbprint. </param>
        /// <param name="expiryUtc"> The certificate expiry date. </param>
        /// <param name="notBeforeUtc"> The certificate not before date. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Models.SphereCertificateProperties"/> instance for mocking. </returns>
        public static SphereCertificateProperties SphereCertificateProperties(string certificate = null, SphereCertificateStatus? status = null, string subject = null, string thumbprint = null, DateTimeOffset? expiryUtc = null, DateTimeOffset? notBeforeUtc = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereCertificateProperties(
                certificate,
                status,
                subject,
                thumbprint,
                expiryUtc,
                notBeforeUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SphereCertificateChainResult"/>. </summary>
        /// <param name="certificateChain"> The certificate chain. </param>
        /// <returns> A new <see cref="Models.SphereCertificateChainResult"/> instance for mocking. </returns>
        public static SphereCertificateChainResult SphereCertificateChainResult(string certificateChain = null)
        {
            return new SphereCertificateChainResult(certificateChain, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProofOfPossessionNonceResponse"/>. </summary>
        /// <param name="certificate"> The certificate as a UTF-8 encoded base 64 string. </param>
        /// <param name="status"> The certificate status. </param>
        /// <param name="subject"> The certificate subject. </param>
        /// <param name="thumbprint"> The certificate thumbprint. </param>
        /// <param name="expiryUtc"> The certificate expiry date. </param>
        /// <param name="notBeforeUtc"> The certificate not before date. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Models.ProofOfPossessionNonceResponse"/> instance for mocking. </returns>
        public static ProofOfPossessionNonceResponse ProofOfPossessionNonceResponse(string certificate = null, SphereCertificateStatus? status = null, string subject = null, string thumbprint = null, DateTimeOffset? expiryUtc = null, DateTimeOffset? notBeforeUtc = null, SphereProvisioningState? provisioningState = null)
        {
            return new ProofOfPossessionNonceResponse(
                certificate,
                status,
                subject,
                thumbprint,
                expiryUtc,
                notBeforeUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CountDevicesResult"/>. </summary>
        /// <param name="value"> Number of children resources in parent resource. </param>
        /// <returns> A new <see cref="Models.CountDevicesResult"/> instance for mocking. </returns>
        public static CountDevicesResult CountDevicesResult(int value = default)
        {
            return new CountDevicesResult(value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CountElementsResult"/>. </summary>
        /// <param name="value"> Number of children resources in parent resource. </param>
        /// <returns> A new <see cref="Models.CountElementsResult"/> instance for mocking. </returns>
        public static CountElementsResult CountElementsResult(int value = default)
        {
            return new CountElementsResult(value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereImageData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="image"> Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads. </param>
        /// <param name="imageId"> Image ID. </param>
        /// <param name="imageName"> Image name. </param>
        /// <param name="regionalDataBoundary"> Regional data boundary for an image. </param>
        /// <param name="uri"> Location the image. </param>
        /// <param name="description"> The image description. </param>
        /// <param name="componentId"> The image component id. </param>
        /// <param name="imageType"> The image type. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereImageData"/> instance for mocking. </returns>
        public static SphereImageData SphereImageData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string image = null, string imageId = null, string imageName = null, RegionalDataBoundary? regionalDataBoundary = null, Uri uri = null, string description = null, string componentId = null, SphereImageType? imageType = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereImageData(
                id,
                name,
                resourceType,
                systemData,
                image,
                imageId,
                imageName,
                regionalDataBoundary,
                uri,
                description,
                componentId,
                imageType,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereDeploymentData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="deploymentId"> Deployment ID. </param>
        /// <param name="deployedImages"> Images deployed. </param>
        /// <param name="deploymentDateUtc"> Deployment date UTC. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereDeploymentData"/> instance for mocking. </returns>
        public static SphereDeploymentData SphereDeploymentData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string deploymentId = null, IEnumerable<SphereImageData> deployedImages = null, DateTimeOffset? deploymentDateUtc = null, SphereProvisioningState? provisioningState = null)
        {
            deployedImages ??= new List<SphereImageData>();

            return new SphereDeploymentData(
                id,
                name,
                resourceType,
                systemData,
                deploymentId,
                deployedImages?.ToList(),
                deploymentDateUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereDeviceGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of the device group. </param>
        /// <param name="osFeedType"> Operating system feed type of the device group. </param>
        /// <param name="updatePolicy"> Update policy of the device group. </param>
        /// <param name="allowCrashDumpsCollection"> Flag to define if the user allows for crash dump collection. </param>
        /// <param name="regionalDataBoundary"> Regional data boundary for the device group. </param>
        /// <param name="hasDeployment"> Deployment status for the device group. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereDeviceGroupData"/> instance for mocking. </returns>
        public static SphereDeviceGroupData SphereDeviceGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, SphereOSFeedType? osFeedType = null, SphereUpdatePolicy? updatePolicy = null, SphereAllowCrashDumpCollectionStatus? allowCrashDumpsCollection = null, RegionalDataBoundary? regionalDataBoundary = null, bool? hasDeployment = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereDeviceGroupData(
                id,
                name,
                resourceType,
                systemData,
                description,
                osFeedType,
                updatePolicy,
                allowCrashDumpsCollection,
                regionalDataBoundary,
                hasDeployment,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SphereDeviceInsight"/>. </summary>
        /// <param name="deviceId"> Device ID. </param>
        /// <param name="description"> Event description. </param>
        /// <param name="startTimestampUtc"> Event start timestamp. </param>
        /// <param name="endTimestampUtc"> Event end timestamp. </param>
        /// <param name="eventCategory"> Event category. </param>
        /// <param name="eventClass"> Event class. </param>
        /// <param name="eventType"> Event type. </param>
        /// <param name="eventCount"> Event count. </param>
        /// <returns> A new <see cref="Models.SphereDeviceInsight"/> instance for mocking. </returns>
        public static SphereDeviceInsight SphereDeviceInsight(string deviceId = null, string description = null, DateTimeOffset startTimestampUtc = default, DateTimeOffset endTimestampUtc = default, string eventCategory = null, string eventClass = null, string eventType = null, int eventCount = default)
        {
            return new SphereDeviceInsight(
                deviceId,
                description,
                startTimestampUtc,
                endTimestampUtc,
                eventCategory,
                eventClass,
                eventType,
                eventCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereDeviceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="deviceId"> Device ID. </param>
        /// <param name="chipSku"> SKU of the chip. </param>
        /// <param name="lastAvailableOSVersion"> OS version available for installation when update requested. </param>
        /// <param name="lastInstalledOSVersion"> OS version running on device when update requested. </param>
        /// <param name="lastOSUpdateUtc"> Time when update requested and new OS version available. </param>
        /// <param name="lastUpdateRequestUtc"> Time when update was last requested. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereDeviceData"/> instance for mocking. </returns>
        public static SphereDeviceData SphereDeviceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string deviceId = null, string chipSku = null, string lastAvailableOSVersion = null, string lastInstalledOSVersion = null, DateTimeOffset? lastOSUpdateUtc = null, DateTimeOffset? lastUpdateRequestUtc = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereDeviceData(
                id,
                name,
                resourceType,
                systemData,
                deviceId,
                chipSku,
                lastAvailableOSVersion,
                lastInstalledOSVersion,
                lastOSUpdateUtc,
                lastUpdateRequestUtc,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Sphere.SphereProductData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> Description of the product. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="Sphere.SphereProductData"/> instance for mocking. </returns>
        public static SphereProductData SphereProductData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string description = null, SphereProvisioningState? provisioningState = null)
        {
            return new SphereProductData(
                id,
                name,
                resourceType,
                systemData,
                description,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SignedCapabilityImageResponse"/>. </summary>
        /// <param name="image"> The signed device capability image as a UTF-8 encoded base 64 string. </param>
        /// <returns> A new <see cref="Models.SignedCapabilityImageResponse"/> instance for mocking. </returns>
        public static SignedCapabilityImageResponse SignedCapabilityImageResponse(string image = null)
        {
            return new SignedCapabilityImageResponse(image, serializedAdditionalRawData: null);
        }
    }
}
