// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.SignalR;

namespace Azure.ResourceManager.SignalR.Samples
{
    public partial class Sample_SignalRSharedPrivateLinkResource
    {
        // SignalRSharedPrivateLinkResources_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SignalRSharedPrivateLinkResourcesGet()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRSharedPrivateLinkResources_Get.json
            // this example is just showing the usage of "SignalRSharedPrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRSharedPrivateLinkResource created on azure
            // for more information of creating SignalRSharedPrivateLinkResource, please refer to the document of SignalRSharedPrivateLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string sharedPrivateLinkResourceName = "upstream";
            ResourceIdentifier signalRSharedPrivateLinkResourceId = SignalRSharedPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, sharedPrivateLinkResourceName);
            SignalRSharedPrivateLinkResource signalRSharedPrivateLinkResource = client.GetSignalRSharedPrivateLinkResource(signalRSharedPrivateLinkResourceId);

            // invoke the operation
            SignalRSharedPrivateLinkResource result = await signalRSharedPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRSharedPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalRSharedPrivateLinkResources_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SignalRSharedPrivateLinkResourcesCreateOrUpdate()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRSharedPrivateLinkResources_CreateOrUpdate.json
            // this example is just showing the usage of "SignalRSharedPrivateLinkResources_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRSharedPrivateLinkResource created on azure
            // for more information of creating SignalRSharedPrivateLinkResource, please refer to the document of SignalRSharedPrivateLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string sharedPrivateLinkResourceName = "upstream";
            ResourceIdentifier signalRSharedPrivateLinkResourceId = SignalRSharedPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, sharedPrivateLinkResourceName);
            SignalRSharedPrivateLinkResource signalRSharedPrivateLinkResource = client.GetSignalRSharedPrivateLinkResource(signalRSharedPrivateLinkResourceId);

            // invoke the operation
            SignalRSharedPrivateLinkResourceData data = new SignalRSharedPrivateLinkResourceData()
            {
                GroupId = "sites",
                PrivateLinkResourceId = new ResourceIdentifier("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/Microsoft.Web/sites/myWebApp"),
                RequestMessage = "Please approve",
            };
            ArmOperation<SignalRSharedPrivateLinkResource> lro = await signalRSharedPrivateLinkResource.UpdateAsync(WaitUntil.Completed, data);
            SignalRSharedPrivateLinkResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRSharedPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalRSharedPrivateLinkResources_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SignalRSharedPrivateLinkResourcesDelete()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRSharedPrivateLinkResources_Delete.json
            // this example is just showing the usage of "SignalRSharedPrivateLinkResources_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRSharedPrivateLinkResource created on azure
            // for more information of creating SignalRSharedPrivateLinkResource, please refer to the document of SignalRSharedPrivateLinkResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string sharedPrivateLinkResourceName = "upstream";
            ResourceIdentifier signalRSharedPrivateLinkResourceId = SignalRSharedPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, sharedPrivateLinkResourceName);
            SignalRSharedPrivateLinkResource signalRSharedPrivateLinkResource = client.GetSignalRSharedPrivateLinkResource(signalRSharedPrivateLinkResourceId);

            // invoke the operation
            await signalRSharedPrivateLinkResource.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
