// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SignalR;
using Azure.ResourceManager.SignalR.Models;

namespace Azure.ResourceManager.SignalR.Samples
{
    public partial class Sample_SignalRResource
    {
        // SignalR_CheckNameAvailability
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CheckSignalRNameAvailability_SignalRCheckNameAvailability()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_CheckNameAvailability.json
            // this example is just showing the usage of "SignalR_CheckNameAvailability" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            AzureLocation location = new AzureLocation("eastus");
            SignalRNameAvailabilityContent content = new SignalRNameAvailabilityContent(new ResourceType("Microsoft.SignalRService/SignalR"), "mySignalRService");
            SignalRNameAvailabilityResult result = await subscriptionResource.CheckSignalRNameAvailabilityAsync(location, content);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SignalR_ListBySubscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSignalRs_SignalRListBySubscription()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_ListBySubscription.json
            // this example is just showing the usage of "SignalR_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (SignalRResource item in subscriptionResource.GetSignalRsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SignalRData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SignalR_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SignalRGet()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Get.json
            // this example is just showing the usage of "SignalR_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            SignalRResource result = await signalR.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalR_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SignalRDelete()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Delete.json
            // this example is just showing the usage of "SignalR_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            await signalR.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // SignalR_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SignalRUpdate()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Update.json
            // this example is just showing the usage of "SignalR_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            SignalRData data = new SignalRData(new AzureLocation("eastus"))
            {
                Sku = new SignalRResourceSku("Standard_S1")
                {
                    Tier = SignalRSkuTier.Standard,
                    Capacity = 1,
                },
                Kind = SignalRServiceKind.SignalR,
                Identity = new ManagedServiceIdentity("SystemAssigned"),
                IsClientCertEnabled = false,
                Features =
{
new SignalRFeature(SignalRFeatureFlag.ServiceMode,"Serverless")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableConnectivityLogs,"True")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableMessagingLogs,"False")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableLiveTrace,"False")
{
Properties =
{
},
}
},
                LiveTraceConfiguration = new SignalRLiveTraceConfiguration()
                {
                    Enabled = "false",
                    Categories =
{
new SignalRLiveTraceCategory()
{
Name = "ConnectivityLogs",
Enabled = "true",
}
},
                },
                CorsAllowedOrigins =
{
"https://foo.com","https://bar.com"
},
                UpstreamTemplates =
{
new SignalRUpstreamTemplate("https://example.com/chat/api/connect")
{
HubPattern = "*",
EventPattern = "connect,disconnect",
CategoryPattern = "*",
Auth = new SignalRUpstreamAuthSettings()
{
AuthType = SignalRUpstreamAuthType.ManagedIdentity,
ManagedIdentityResource = "api://example",
},
}
},
                NetworkACLs = new SignalRNetworkAcls()
                {
                    DefaultAction = SignalRNetworkAclAction.Deny,
                    PublicNetwork = new SignalRNetworkAcl()
                    {
                        Allow =
{
SignalRRequestType.ClientConnection
},
                    },
                    PrivateEndpoints =
{
new SignalRPrivateEndpointAcl("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
{
Allow =
{
SignalRRequestType.ServerConnection
},
}
},
                },
                PublicNetworkAccess = "Enabled",
                DisableLocalAuth = false,
                DisableAadAuth = false,
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<SignalRResource> lro = await signalR.UpdateAsync(WaitUntil.Completed, data);
            SignalRResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalR_ListKeys
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_SignalRListKeys()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_ListKeys.json
            // this example is just showing the usage of "SignalR_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            SignalRKeys result = await signalR.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // SignalR_RegenerateKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateKey_SignalRRegenerateKey()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_RegenerateKey.json
            // this example is just showing the usage of "SignalR_RegenerateKey" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            SignalRRegenerateKeyContent content = new SignalRRegenerateKeyContent()
            {
                KeyType = SignalRKeyType.Primary,
            };
            ArmOperation<SignalRKeys> lro = await signalR.RegenerateKeyAsync(WaitUntil.Completed, content);
            SignalRKeys result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // SignalR_Restart
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Restart_SignalRRestart()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Restart.json
            // this example is just showing the usage of "SignalR_Restart" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation
            await signalR.RestartAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // SignalR_ListSkus
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSkus_SignalRListSkus()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_ListSkus.json
            // this example is just showing the usage of "SignalR_ListSkus" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation and iterate over the result
            await foreach (SignalRSku item in signalR.GetSkusAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SignalRPrivateLinkResources_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSignalRPrivateLinkResources_SignalRPrivateLinkResourcesList()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRPrivateLinkResources_List.json
            // this example is just showing the usage of "SignalRPrivateLinkResources_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRResource created on azure
            // for more information of creating SignalRResource, please refer to the document of SignalRResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            ResourceIdentifier signalRResourceId = SignalRResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            SignalRResource signalR = client.GetSignalRResource(signalRResourceId);

            // invoke the operation and iterate over the result
            await foreach (SignalRPrivateLinkResource item in signalR.GetSignalRPrivateLinkResourcesAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
