// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.SignalR;

namespace Azure.ResourceManager.SignalR.Samples
{
    public partial class Sample_SignalRCustomCertificateResource
    {
        // SignalRCustomCertificates_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SignalRCustomCertificatesGet()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRCustomCertificates_Get.json
            // this example is just showing the usage of "SignalRCustomCertificates_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRCustomCertificateResource created on azure
            // for more information of creating SignalRCustomCertificateResource, please refer to the document of SignalRCustomCertificateResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string certificateName = "myCert";
            ResourceIdentifier signalRCustomCertificateResourceId = SignalRCustomCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, certificateName);
            SignalRCustomCertificateResource signalRCustomCertificate = client.GetSignalRCustomCertificateResource(signalRCustomCertificateResourceId);

            // invoke the operation
            SignalRCustomCertificateResource result = await signalRCustomCertificate.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRCustomCertificateData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalRCustomCertificates_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SignalRCustomCertificatesCreateOrUpdate()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRCustomCertificates_CreateOrUpdate.json
            // this example is just showing the usage of "SignalRCustomCertificates_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRCustomCertificateResource created on azure
            // for more information of creating SignalRCustomCertificateResource, please refer to the document of SignalRCustomCertificateResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string certificateName = "myCert";
            ResourceIdentifier signalRCustomCertificateResourceId = SignalRCustomCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, certificateName);
            SignalRCustomCertificateResource signalRCustomCertificate = client.GetSignalRCustomCertificateResource(signalRCustomCertificateResourceId);

            // invoke the operation
            SignalRCustomCertificateData data = new SignalRCustomCertificateData(new Uri("https://myvault.keyvault.azure.net/"), "mycert")
            {
                KeyVaultSecretVersion = "bb6a44b2743f47f68dad0d6cc9756432",
            };
            ArmOperation<SignalRCustomCertificateResource> lro = await signalRCustomCertificate.UpdateAsync(WaitUntil.Completed, data);
            SignalRCustomCertificateResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRCustomCertificateData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalRCustomCertificates_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SignalRCustomCertificatesDelete()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalRCustomCertificates_Delete.json
            // this example is just showing the usage of "SignalRCustomCertificates_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SignalRCustomCertificateResource created on azure
            // for more information of creating SignalRCustomCertificateResource, please refer to the document of SignalRCustomCertificateResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            string resourceName = "mySignalRService";
            string certificateName = "myCert";
            ResourceIdentifier signalRCustomCertificateResourceId = SignalRCustomCertificateResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, certificateName);
            SignalRCustomCertificateResource signalRCustomCertificate = client.GetSignalRCustomCertificateResource(signalRCustomCertificateResourceId);

            // invoke the operation
            await signalRCustomCertificate.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
