// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SignalR;
using Azure.ResourceManager.SignalR.Models;

namespace Azure.ResourceManager.SignalR.Samples
{
    public partial class Sample_SignalRCollection
    {
        // SignalR_ListByResourceGroup
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SignalRListByResourceGroup()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_ListByResourceGroup.json
            // this example is just showing the usage of "SignalR_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this SignalRResource
            SignalRCollection collection = resourceGroupResource.GetSignalRs();

            // invoke the operation and iterate over the result
            await foreach (SignalRResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SignalRData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // SignalR_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SignalRGet()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Get.json
            // this example is just showing the usage of "SignalR_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this SignalRResource
            SignalRCollection collection = resourceGroupResource.GetSignalRs();

            // invoke the operation
            string resourceName = "mySignalRService";
            SignalRResource result = await collection.GetAsync(resourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // SignalR_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SignalRGet()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_Get.json
            // this example is just showing the usage of "SignalR_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this SignalRResource
            SignalRCollection collection = resourceGroupResource.GetSignalRs();

            // invoke the operation
            string resourceName = "mySignalRService";
            bool result = await collection.ExistsAsync(resourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // SignalR_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SignalRCreateOrUpdate()
        {
            // Generated from example definition: specification/signalr/resource-manager/Microsoft.SignalRService/stable/2022-02-01/examples/SignalR_CreateOrUpdate.json
            // this example is just showing the usage of "SignalR_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this SignalRResource
            SignalRCollection collection = resourceGroupResource.GetSignalRs();

            // invoke the operation
            string resourceName = "mySignalRService";
            SignalRData data = new SignalRData(new AzureLocation("eastus"))
            {
                Sku = new SignalRResourceSku("Standard_S1")
                {
                    Tier = SignalRSkuTier.Standard,
                    Capacity = 1,
                },
                Kind = SignalRServiceKind.SignalR,
                Identity = new ManagedServiceIdentity("SystemAssigned"),
                IsClientCertEnabled = false,
                Features =
{
new SignalRFeature(SignalRFeatureFlag.ServiceMode,"Serverless")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableConnectivityLogs,"True")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableMessagingLogs,"False")
{
Properties =
{
},
},new SignalRFeature(SignalRFeatureFlag.EnableLiveTrace,"False")
{
Properties =
{
},
}
},
                LiveTraceConfiguration = new SignalRLiveTraceConfiguration()
                {
                    Enabled = "false",
                    Categories =
{
new SignalRLiveTraceCategory()
{
Name = "ConnectivityLogs",
Enabled = "true",
}
},
                },
                CorsAllowedOrigins =
{
"https://foo.com","https://bar.com"
},
                UpstreamTemplates =
{
new SignalRUpstreamTemplate("https://example.com/chat/api/connect")
{
HubPattern = "*",
EventPattern = "connect,disconnect",
CategoryPattern = "*",
Auth = new SignalRUpstreamAuthSettings()
{
AuthType = SignalRUpstreamAuthType.ManagedIdentity,
ManagedIdentityResource = "api://example",
},
}
},
                NetworkACLs = new SignalRNetworkAcls()
                {
                    DefaultAction = SignalRNetworkAclAction.Deny,
                    PublicNetwork = new SignalRNetworkAcl()
                    {
                        Allow =
{
SignalRRequestType.ClientConnection
},
                    },
                    PrivateEndpoints =
{
new SignalRPrivateEndpointAcl("mysignalrservice.1fa229cd-bf3f-47f0-8c49-afb36723997e")
{
Allow =
{
SignalRRequestType.ServerConnection
},
}
},
                },
                PublicNetworkAccess = "Enabled",
                DisableLocalAuth = false,
                DisableAadAuth = false,
                Tags =
{
["key1"] = "value1",
},
            };
            ArmOperation<SignalRResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, resourceName, data);
            SignalRResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SignalRData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
