// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SignalR.Models;

namespace Azure.ResourceManager.SignalR
{
    /// <summary>
    /// A class representing the SignalRSharedPrivateLinkResource data model.
    /// Describes a Shared Private Link Resource
    /// </summary>
    public partial class SignalRSharedPrivateLinkResourceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SignalRSharedPrivateLinkResourceData"/>. </summary>
        public SignalRSharedPrivateLinkResourceData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SignalRSharedPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The group id from the provider of resource the shared private link resource is for. </param>
        /// <param name="privateLinkResourceId"> The resource id of the resource the shared private link resource is for. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="requestMessage"> The request message for requesting approval of the shared private link resource. </param>
        /// <param name="status"> Status of the shared private link resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SignalRSharedPrivateLinkResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string groupId, ResourceIdentifier privateLinkResourceId, SignalRProvisioningState? provisioningState, string requestMessage, SignalRSharedPrivateLinkResourceStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            GroupId = groupId;
            PrivateLinkResourceId = privateLinkResourceId;
            ProvisioningState = provisioningState;
            RequestMessage = requestMessage;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The group id from the provider of resource the shared private link resource is for. </summary>
        [WirePath("properties.groupId")]
        public string GroupId { get; set; }
        /// <summary> The resource id of the resource the shared private link resource is for. </summary>
        [WirePath("properties.privateLinkResourceId")]
        public ResourceIdentifier PrivateLinkResourceId { get; set; }
        /// <summary> Provisioning state of the resource. </summary>
        [WirePath("properties.provisioningState")]
        public SignalRProvisioningState? ProvisioningState { get; }
        /// <summary> The request message for requesting approval of the shared private link resource. </summary>
        [WirePath("properties.requestMessage")]
        public string RequestMessage { get; set; }
        /// <summary> Status of the shared private link resource. </summary>
        [WirePath("properties.status")]
        public SignalRSharedPrivateLinkResourceStatus? Status { get; }
    }
}
