// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SignalR.Models
{
    public partial class SignalRUpstreamTemplate : IUtf8JsonSerializable, IJsonModel<SignalRUpstreamTemplate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SignalRUpstreamTemplate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SignalRUpstreamTemplate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SignalRUpstreamTemplate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SignalRUpstreamTemplate)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(HubPattern))
            {
                writer.WritePropertyName("hubPattern"u8);
                writer.WriteStringValue(HubPattern);
            }
            if (Optional.IsDefined(EventPattern))
            {
                writer.WritePropertyName("eventPattern"u8);
                writer.WriteStringValue(EventPattern);
            }
            if (Optional.IsDefined(CategoryPattern))
            {
                writer.WritePropertyName("categoryPattern"u8);
                writer.WriteStringValue(CategoryPattern);
            }
            writer.WritePropertyName("urlTemplate"u8);
            writer.WriteStringValue(UrlTemplate);
            if (Optional.IsDefined(Auth))
            {
                writer.WritePropertyName("auth"u8);
                writer.WriteObjectValue(Auth, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SignalRUpstreamTemplate IJsonModel<SignalRUpstreamTemplate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SignalRUpstreamTemplate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SignalRUpstreamTemplate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSignalRUpstreamTemplate(document.RootElement, options);
        }

        internal static SignalRUpstreamTemplate DeserializeSignalRUpstreamTemplate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string hubPattern = default;
            string eventPattern = default;
            string categoryPattern = default;
            string urlTemplate = default;
            SignalRUpstreamAuthSettings auth = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("hubPattern"u8))
                {
                    hubPattern = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eventPattern"u8))
                {
                    eventPattern = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("categoryPattern"u8))
                {
                    categoryPattern = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("urlTemplate"u8))
                {
                    urlTemplate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("auth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    auth = SignalRUpstreamAuthSettings.DeserializeSignalRUpstreamAuthSettings(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SignalRUpstreamTemplate(
                hubPattern,
                eventPattern,
                categoryPattern,
                urlTemplate,
                auth,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HubPattern), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hubPattern: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HubPattern))
                {
                    builder.Append("  hubPattern: ");
                    if (HubPattern.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{HubPattern}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{HubPattern}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EventPattern), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  eventPattern: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EventPattern))
                {
                    builder.Append("  eventPattern: ");
                    if (EventPattern.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EventPattern}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EventPattern}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CategoryPattern), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  categoryPattern: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CategoryPattern))
                {
                    builder.Append("  categoryPattern: ");
                    if (CategoryPattern.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CategoryPattern}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CategoryPattern}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(UrlTemplate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  urlTemplate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(UrlTemplate))
                {
                    builder.Append("  urlTemplate: ");
                    if (UrlTemplate.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{UrlTemplate}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{UrlTemplate}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Auth), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  auth: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Auth))
                {
                    builder.Append("  auth: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Auth, options, 2, false, "  auth: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SignalRUpstreamTemplate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SignalRUpstreamTemplate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SignalRUpstreamTemplate)} does not support writing '{options.Format}' format.");
            }
        }

        SignalRUpstreamTemplate IPersistableModel<SignalRUpstreamTemplate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SignalRUpstreamTemplate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSignalRUpstreamTemplate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SignalRUpstreamTemplate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SignalRUpstreamTemplate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
