// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> Upstream auth type enum. </summary>
    public readonly partial struct SignalRUpstreamAuthType : IEquatable<SignalRUpstreamAuthType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRUpstreamAuthType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRUpstreamAuthType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManagedIdentityValue = "ManagedIdentity";

        /// <summary> None. </summary>
        public static SignalRUpstreamAuthType None { get; } = new SignalRUpstreamAuthType(NoneValue);
        /// <summary> ManagedIdentity. </summary>
        public static SignalRUpstreamAuthType ManagedIdentity { get; } = new SignalRUpstreamAuthType(ManagedIdentityValue);
        /// <summary> Determines if two <see cref="SignalRUpstreamAuthType"/> values are the same. </summary>
        public static bool operator ==(SignalRUpstreamAuthType left, SignalRUpstreamAuthType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRUpstreamAuthType"/> values are not the same. </summary>
        public static bool operator !=(SignalRUpstreamAuthType left, SignalRUpstreamAuthType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRUpstreamAuthType"/>. </summary>
        public static implicit operator SignalRUpstreamAuthType(string value) => new SignalRUpstreamAuthType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRUpstreamAuthType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRUpstreamAuthType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
