// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> Upstream auth settings. If not set, no auth is used for upstream messages. </summary>
    public partial class SignalRUpstreamAuthSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SignalRUpstreamAuthSettings"/>. </summary>
        public SignalRUpstreamAuthSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SignalRUpstreamAuthSettings"/>. </summary>
        /// <param name="authType"> Upstream auth type enum. </param>
        /// <param name="managedIdentity"> Managed identity settings for upstream. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SignalRUpstreamAuthSettings(SignalRUpstreamAuthType? authType, ManagedIdentitySettings managedIdentity, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthType = authType;
            ManagedIdentity = managedIdentity;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Upstream auth type enum. </summary>
        [WirePath("type")]
        public SignalRUpstreamAuthType? AuthType { get; set; }
        /// <summary> Managed identity settings for upstream. </summary>
        internal ManagedIdentitySettings ManagedIdentity { get; set; }
        /// <summary>
        /// The Resource indicating the App ID URI of the target resource.
        /// It also appears in the aud (audience) claim of the issued token.
        /// </summary>
        [WirePath("managedIdentity.resource")]
        public string ManagedIdentityResource
        {
            get => ManagedIdentity is null ? default : ManagedIdentity.Resource;
            set
            {
                if (ManagedIdentity is null)
                    ManagedIdentity = new ManagedIdentitySettings();
                ManagedIdentity.Resource = value;
            }
        }
    }
}
