// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary>
    /// Optional tier of this particular SKU. 'Standard' or 'Free'.
    ///
    /// `Basic` is deprecated, use `Standard` instead.
    /// </summary>
    public readonly partial struct SignalRSkuTier : IEquatable<SignalRSkuTier>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRSkuTier"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRSkuTier(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FreeValue = "Free";
        private const string BasicValue = "Basic";
        private const string StandardValue = "Standard";
        private const string PremiumValue = "Premium";

        /// <summary> Free. </summary>
        public static SignalRSkuTier Free { get; } = new SignalRSkuTier(FreeValue);
        /// <summary> Basic. </summary>
        public static SignalRSkuTier Basic { get; } = new SignalRSkuTier(BasicValue);
        /// <summary> Standard. </summary>
        public static SignalRSkuTier Standard { get; } = new SignalRSkuTier(StandardValue);
        /// <summary> Premium. </summary>
        public static SignalRSkuTier Premium { get; } = new SignalRSkuTier(PremiumValue);
        /// <summary> Determines if two <see cref="SignalRSkuTier"/> values are the same. </summary>
        public static bool operator ==(SignalRSkuTier left, SignalRSkuTier right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRSkuTier"/> values are not the same. </summary>
        public static bool operator !=(SignalRSkuTier left, SignalRSkuTier right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRSkuTier"/>. </summary>
        public static implicit operator SignalRSkuTier(string value) => new SignalRSkuTier(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRSkuTier other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRSkuTier other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
