// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> The kind of the service, it can be SignalR or RawWebSockets. </summary>
    public readonly partial struct SignalRServiceKind : IEquatable<SignalRServiceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRServiceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRServiceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SignalRValue = "SignalR";
        private const string RawWebSocketsValue = "RawWebSockets";

        /// <summary> SignalR. </summary>
        public static SignalRServiceKind SignalR { get; } = new SignalRServiceKind(SignalRValue);
        /// <summary> RawWebSockets. </summary>
        public static SignalRServiceKind RawWebSockets { get; } = new SignalRServiceKind(RawWebSocketsValue);
        /// <summary> Determines if two <see cref="SignalRServiceKind"/> values are the same. </summary>
        public static bool operator ==(SignalRServiceKind left, SignalRServiceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRServiceKind"/> values are not the same. </summary>
        public static bool operator !=(SignalRServiceKind left, SignalRServiceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRServiceKind"/>. </summary>
        public static implicit operator SignalRServiceKind(string value) => new SignalRServiceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRServiceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRServiceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
