// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> The incoming request type to the service. </summary>
    public readonly partial struct SignalRRequestType : IEquatable<SignalRRequestType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRRequestType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRRequestType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClientConnectionValue = "ClientConnection";
        private const string ServerConnectionValue = "ServerConnection";
        private const string RestApiValue = "RESTAPI";
        private const string TraceValue = "Trace";

        /// <summary> ClientConnection. </summary>
        public static SignalRRequestType ClientConnection { get; } = new SignalRRequestType(ClientConnectionValue);
        /// <summary> ServerConnection. </summary>
        public static SignalRRequestType ServerConnection { get; } = new SignalRRequestType(ServerConnectionValue);
        /// <summary> RESTAPI. </summary>
        public static SignalRRequestType RestApi { get; } = new SignalRRequestType(RestApiValue);
        /// <summary> Trace. </summary>
        public static SignalRRequestType Trace { get; } = new SignalRRequestType(TraceValue);
        /// <summary> Determines if two <see cref="SignalRRequestType"/> values are the same. </summary>
        public static bool operator ==(SignalRRequestType left, SignalRRequestType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRRequestType"/> values are not the same. </summary>
        public static bool operator !=(SignalRRequestType left, SignalRRequestType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRRequestType"/>. </summary>
        public static implicit operator SignalRRequestType(string value) => new SignalRRequestType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRRequestType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRRequestType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
