// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> Azure Networking ACL Action. </summary>
    public readonly partial struct SignalRNetworkAclAction : IEquatable<SignalRNetworkAclAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRNetworkAclAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRNetworkAclAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static SignalRNetworkAclAction Allow { get; } = new SignalRNetworkAclAction(AllowValue);
        /// <summary> Deny. </summary>
        public static SignalRNetworkAclAction Deny { get; } = new SignalRNetworkAclAction(DenyValue);
        /// <summary> Determines if two <see cref="SignalRNetworkAclAction"/> values are the same. </summary>
        public static bool operator ==(SignalRNetworkAclAction left, SignalRNetworkAclAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRNetworkAclAction"/> values are not the same. </summary>
        public static bool operator !=(SignalRNetworkAclAction left, SignalRNetworkAclAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRNetworkAclAction"/>. </summary>
        public static implicit operator SignalRNetworkAclAction(string value) => new SignalRNetworkAclAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRNetworkAclAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRNetworkAclAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
