// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> Live trace configuration of a Microsoft.SignalRService resource. </summary>
    public partial class SignalRLiveTraceConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SignalRLiveTraceConfiguration"/>. </summary>
        public SignalRLiveTraceConfiguration()
        {
            Categories = new ChangeTrackingList<SignalRLiveTraceCategory>();
        }

        /// <summary> Initializes a new instance of <see cref="SignalRLiveTraceConfiguration"/>. </summary>
        /// <param name="enabled">
        /// Indicates whether or not enable live trace.
        /// When it's set to true, live trace client can connect to the service.
        /// Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
        /// Available values: true, false.
        /// Case insensitive.
        /// </param>
        /// <param name="categories"> Gets or sets the list of category configurations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SignalRLiveTraceConfiguration(string enabled, IList<SignalRLiveTraceCategory> categories, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Enabled = enabled;
            Categories = categories;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// Indicates whether or not enable live trace.
        /// When it's set to true, live trace client can connect to the service.
        /// Otherwise, live trace client can't connect to the service, so that you are unable to receive any log, no matter what you configure in "categories".
        /// Available values: true, false.
        /// Case insensitive.
        /// </summary>
        [WirePath("enabled")]
        public string Enabled { get; set; }
        /// <summary> Gets or sets the list of category configurations. </summary>
        [WirePath("categories")]
        public IList<SignalRLiveTraceCategory> Categories { get; }
    }
}
