// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> The type of access key. </summary>
    public readonly partial struct SignalRKeyType : IEquatable<SignalRKeyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SignalRKeyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRKeyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimaryValue = "Primary";
        private const string SecondaryValue = "Secondary";
        private const string SaltValue = "Salt";

        /// <summary> Primary. </summary>
        public static SignalRKeyType Primary { get; } = new SignalRKeyType(PrimaryValue);
        /// <summary> Secondary. </summary>
        public static SignalRKeyType Secondary { get; } = new SignalRKeyType(SecondaryValue);
        /// <summary> Salt. </summary>
        public static SignalRKeyType Salt { get; } = new SignalRKeyType(SaltValue);
        /// <summary> Determines if two <see cref="SignalRKeyType"/> values are the same. </summary>
        public static bool operator ==(SignalRKeyType left, SignalRKeyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SignalRKeyType"/> values are not the same. </summary>
        public static bool operator !=(SignalRKeyType left, SignalRKeyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SignalRKeyType"/>. </summary>
        public static implicit operator SignalRKeyType(string value) => new SignalRKeyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SignalRKeyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SignalRKeyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
