// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SignalR.Models
{
    /// <summary> Feature of a resource, which controls the runtime behavior. </summary>
    public partial class SignalRFeature
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SignalRFeature"/>. </summary>
        /// <param name="flag">
        /// FeatureFlags is the supported features of Azure SignalR service.
        /// - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
        /// - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
        /// </param>
        /// <param name="value"> Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SignalRFeature(SignalRFeatureFlag flag, string value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Flag = flag;
            Value = value;
            Properties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="SignalRFeature"/>. </summary>
        /// <param name="flag">
        /// FeatureFlags is the supported features of Azure SignalR service.
        /// - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
        /// - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
        /// </param>
        /// <param name="value"> Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values. </param>
        /// <param name="properties"> Optional properties related to this feature. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SignalRFeature(SignalRFeatureFlag flag, string value, IDictionary<string, string> properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Flag = flag;
            Value = value;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SignalRFeature"/> for deserialization. </summary>
        internal SignalRFeature()
        {
        }

        /// <summary>
        /// FeatureFlags is the supported features of Azure SignalR service.
        /// - ServiceMode: Flag for backend server for SignalR service. Values allowed: "Default": have your own backend server; "Serverless": your application doesn't have a backend server; "Classic": for backward compatibility. Support both Default and Serverless mode but not recommended; "PredefinedOnly": for future use.
        /// - EnableConnectivityLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableMessagingLogs: "true"/"false", to enable/disable the connectivity log category respectively.
        /// - EnableLiveTrace: Live Trace allows you to know what's happening inside Azure SignalR service, it will give you live traces in real time, it will be helpful when you developing your own Azure SignalR based web application or self-troubleshooting some issues. Please note that live traces are counted as outbound messages that will be charged. Values allowed: "true"/"false", to enable/disable live trace feature.
        /// </summary>
        [WirePath("flag")]
        public SignalRFeatureFlag Flag { get; set; }
        /// <summary> Value of the feature flag. See Azure SignalR service document https://docs.microsoft.com/azure/azure-signalr/ for allowed values. </summary>
        [WirePath("value")]
        public string Value { get; set; }
        /// <summary> Optional properties related to this feature. </summary>
        [WirePath("properties")]
        public IDictionary<string, string> Properties { get; }
    }
}
