// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SignalR
{
    internal class SignalRCustomCertificateOperationSource : IOperationSource<SignalRCustomCertificateResource>
    {
        private readonly ArmClient _client;

        internal SignalRCustomCertificateOperationSource(ArmClient client)
        {
            _client = client;
        }

        SignalRCustomCertificateResource IOperationSource<SignalRCustomCertificateResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SignalRCustomCertificateData.DeserializeSignalRCustomCertificateData(document.RootElement);
            return new SignalRCustomCertificateResource(_client, data);
        }

        async ValueTask<SignalRCustomCertificateResource> IOperationSource<SignalRCustomCertificateResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SignalRCustomCertificateData.DeserializeSignalRCustomCertificateData(document.RootElement);
            return new SignalRCustomCertificateResource(_client, data);
        }
    }
}
