// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.ServiceNetworking
{
    internal class TrafficControllerOperationSource : IOperationSource<TrafficControllerResource>
    {
        private readonly ArmClient _client;

        internal TrafficControllerOperationSource(ArmClient client)
        {
            _client = client;
        }

        TrafficControllerResource IOperationSource<TrafficControllerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = TrafficControllerData.DeserializeTrafficControllerData(document.RootElement);
            return new TrafficControllerResource(_client, data);
        }

        async ValueTask<TrafficControllerResource> IOperationSource<TrafficControllerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = TrafficControllerData.DeserializeTrafficControllerData(document.RootElement);
            return new TrafficControllerResource(_client, data);
        }
    }
}
