// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.ServiceNetworking.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableServiceNetworkingArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableServiceNetworkingArmClient"/> class for mocking. </summary>
        protected MockableServiceNetworkingArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableServiceNetworkingArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableServiceNetworkingArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableServiceNetworkingArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="TrafficControllerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TrafficControllerResource.CreateResourceIdentifier" /> to create a <see cref="TrafficControllerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TrafficControllerResource"/> object. </returns>
        public virtual TrafficControllerResource GetTrafficControllerResource(ResourceIdentifier id)
        {
            TrafficControllerResource.ValidateResourceId(id);
            return new TrafficControllerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AssociationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AssociationResource.CreateResourceIdentifier" /> to create an <see cref="AssociationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AssociationResource"/> object. </returns>
        public virtual AssociationResource GetAssociationResource(ResourceIdentifier id)
        {
            AssociationResource.ValidateResourceId(id);
            return new AssociationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="FrontendResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="FrontendResource.CreateResourceIdentifier" /> to create a <see cref="FrontendResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="FrontendResource"/> object. </returns>
        public virtual FrontendResource GetFrontendResource(ResourceIdentifier id)
        {
            FrontendResource.ValidateResourceId(id);
            return new FrontendResource(Client, id);
        }
    }
}
