// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ServiceNetworking.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmServiceNetworkingModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="ServiceNetworking.TrafficControllerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="configurationEndpoints"> Configuration Endpoints. </param>
        /// <param name="frontends"> Frontends References List. </param>
        /// <param name="associations"> Associations References List. </param>
        /// <param name="provisioningState"> The status of the last operation. </param>
        /// <returns> A new <see cref="ServiceNetworking.TrafficControllerData"/> instance for mocking. </returns>
        public static TrafficControllerData TrafficControllerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<string> configurationEndpoints = null, IEnumerable<SubResource> frontends = null, IEnumerable<SubResource> associations = null, ProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            configurationEndpoints ??= new List<string>();
            frontends ??= new List<SubResource>();
            associations ??= new List<SubResource>();

            return new TrafficControllerData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                configurationEndpoints?.ToList(),
                frontends?.ToList(),
                associations?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ServiceNetworking.AssociationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="associationType"> Association Type. </param>
        /// <param name="subnetId"> Association Subnet. </param>
        /// <param name="provisioningState"> Provisioning State of Traffic Controller Association Resource. </param>
        /// <returns> A new <see cref="ServiceNetworking.AssociationData"/> instance for mocking. </returns>
        public static AssociationData AssociationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, AssociationType? associationType = null, ResourceIdentifier subnetId = null, ProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AssociationData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                associationType,
                subnetId != null ? ResourceManagerModelFactory.WritableSubResource(subnetId) : null,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="ServiceNetworking.FrontendData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="fqdn"> The Fully Qualified Domain Name of the DNS record associated to a Traffic Controller frontend. </param>
        /// <param name="provisioningState"> Provisioning State of Traffic Controller Frontend Resource. </param>
        /// <returns> A new <see cref="ServiceNetworking.FrontendData"/> instance for mocking. </returns>
        public static FrontendData FrontendData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string fqdn = null, ProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new FrontendData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                fqdn,
                provisioningState,
                serializedAdditionalRawData: null);
        }
    }
}
