// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> Type of VNet solution. </summary>
    public readonly partial struct VnetSolutionType : IEquatable<VnetSolutionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VnetSolutionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VnetSolutionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ServiceEndpointValue = "serviceEndpoint";
        private const string PrivateLinkValue = "privateLink";

        /// <summary> serviceEndpoint. </summary>
        public static VnetSolutionType ServiceEndpoint { get; } = new VnetSolutionType(ServiceEndpointValue);
        /// <summary> privateLink. </summary>
        public static VnetSolutionType PrivateLink { get; } = new VnetSolutionType(PrivateLinkValue);
        /// <summary> Determines if two <see cref="VnetSolutionType"/> values are the same. </summary>
        public static bool operator ==(VnetSolutionType left, VnetSolutionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VnetSolutionType"/> values are not the same. </summary>
        public static bool operator !=(VnetSolutionType left, VnetSolutionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VnetSolutionType"/>. </summary>
        public static implicit operator VnetSolutionType(string value) => new VnetSolutionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VnetSolutionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VnetSolutionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
