// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The secret info when type is rawValue. It's for scenarios that user input the secret. </summary>
    public partial class RawValueSecretInfo : SecretBaseInfo
    {
        /// <summary> Initializes a new instance of <see cref="RawValueSecretInfo"/>. </summary>
        public RawValueSecretInfo()
        {
            SecretType = LinkerSecretType.RawValue;
        }

        /// <summary> Initializes a new instance of <see cref="RawValueSecretInfo"/>. </summary>
        /// <param name="secretType"> The secret type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> The actual value of the secret. </param>
        internal RawValueSecretInfo(LinkerSecretType secretType, IDictionary<string, BinaryData> serializedAdditionalRawData, string value) : base(secretType, serializedAdditionalRawData)
        {
            Value = value;
            SecretType = secretType;
        }

        /// <summary> The actual value of the secret. </summary>
        public string Value { get; set; }
    }
}
