// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The validation item for a linker. </summary>
    public partial class LinkerValidationResultItemInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LinkerValidationResultItemInfo"/>. </summary>
        internal LinkerValidationResultItemInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LinkerValidationResultItemInfo"/>. </summary>
        /// <param name="name"> The validation item name. </param>
        /// <param name="description"> The display name of validation item. </param>
        /// <param name="result"> The result of validation. </param>
        /// <param name="errorMessage"> The error message of validation result. </param>
        /// <param name="errorCode"> The error code of validation result. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LinkerValidationResultItemInfo(string name, string description, LinkerValidationResultStatus? result, string errorMessage, string errorCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Description = description;
            Result = result;
            ErrorMessage = errorMessage;
            ErrorCode = errorCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The validation item name. </summary>
        public string Name { get; }
        /// <summary> The display name of validation item. </summary>
        public string Description { get; }
        /// <summary> The result of validation. </summary>
        public LinkerValidationResultStatus? Result { get; }
        /// <summary> The error message of validation result. </summary>
        public string ErrorMessage { get; }
        /// <summary> The error code of validation result. </summary>
        public string ErrorCode { get; }
    }
}
