// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    public partial class LinkerValidationResultItemInfo : IUtf8JsonSerializable, IJsonModel<LinkerValidationResultItemInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LinkerValidationResultItemInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LinkerValidationResultItemInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LinkerValidationResultItemInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LinkerValidationResultItemInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(Description))
            {
                if (Description != null)
                {
                    writer.WritePropertyName("description"u8);
                    writer.WriteStringValue(Description);
                }
                else
                {
                    writer.WriteNull("description");
                }
            }
            if (Optional.IsDefined(Result))
            {
                if (Result != null)
                {
                    writer.WritePropertyName("result"u8);
                    writer.WriteStringValue(Result.Value.ToString());
                }
                else
                {
                    writer.WriteNull("result");
                }
            }
            if (Optional.IsDefined(ErrorMessage))
            {
                if (ErrorMessage != null)
                {
                    writer.WritePropertyName("errorMessage"u8);
                    writer.WriteStringValue(ErrorMessage);
                }
                else
                {
                    writer.WriteNull("errorMessage");
                }
            }
            if (Optional.IsDefined(ErrorCode))
            {
                if (ErrorCode != null)
                {
                    writer.WritePropertyName("errorCode"u8);
                    writer.WriteStringValue(ErrorCode);
                }
                else
                {
                    writer.WriteNull("errorCode");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LinkerValidationResultItemInfo IJsonModel<LinkerValidationResultItemInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LinkerValidationResultItemInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LinkerValidationResultItemInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLinkerValidationResultItemInfo(document.RootElement, options);
        }

        internal static LinkerValidationResultItemInfo DeserializeLinkerValidationResultItemInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string description = default;
            LinkerValidationResultStatus? result = default;
            string errorMessage = default;
            string errorCode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        description = null;
                        continue;
                    }
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("result"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        result = null;
                        continue;
                    }
                    result = new LinkerValidationResultStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("errorMessage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        errorMessage = null;
                        continue;
                    }
                    errorMessage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("errorCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        errorCode = null;
                        continue;
                    }
                    errorCode = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LinkerValidationResultItemInfo(
                name,
                description,
                result,
                errorMessage,
                errorCode,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<LinkerValidationResultItemInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LinkerValidationResultItemInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(LinkerValidationResultItemInfo)} does not support writing '{options.Format}' format.");
            }
        }

        LinkerValidationResultItemInfo IPersistableModel<LinkerValidationResultItemInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LinkerValidationResultItemInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLinkerValidationResultItemInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LinkerValidationResultItemInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LinkerValidationResultItemInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
