// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The secret type. </summary>
    internal readonly partial struct LinkerSecretType : IEquatable<LinkerSecretType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinkerSecretType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinkerSecretType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RawValueValue = "rawValue";
        private const string KeyVaultSecretUriValue = "keyVaultSecretUri";
        private const string KeyVaultSecretReferenceValue = "keyVaultSecretReference";

        /// <summary> rawValue. </summary>
        public static LinkerSecretType RawValue { get; } = new LinkerSecretType(RawValueValue);
        /// <summary> keyVaultSecretUri. </summary>
        public static LinkerSecretType KeyVaultSecretUri { get; } = new LinkerSecretType(KeyVaultSecretUriValue);
        /// <summary> keyVaultSecretReference. </summary>
        public static LinkerSecretType KeyVaultSecretReference { get; } = new LinkerSecretType(KeyVaultSecretReferenceValue);
        /// <summary> Determines if two <see cref="LinkerSecretType"/> values are the same. </summary>
        public static bool operator ==(LinkerSecretType left, LinkerSecretType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinkerSecretType"/> values are not the same. </summary>
        public static bool operator !=(LinkerSecretType left, LinkerSecretType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinkerSecretType"/>. </summary>
        public static implicit operator LinkerSecretType(string value) => new LinkerSecretType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinkerSecretType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinkerSecretType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
