// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The authentication type. </summary>
    public readonly partial struct LinkerAuthType : IEquatable<LinkerAuthType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LinkerAuthType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LinkerAuthType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedIdentityValue = "systemAssignedIdentity";
        private const string UserAssignedIdentityValue = "userAssignedIdentity";
        private const string ServicePrincipalSecretValue = "servicePrincipalSecret";
        private const string ServicePrincipalCertificateValue = "servicePrincipalCertificate";
        private const string SecretValue = "secret";

        /// <summary> systemAssignedIdentity. </summary>
        public static LinkerAuthType SystemAssignedIdentity { get; } = new LinkerAuthType(SystemAssignedIdentityValue);
        /// <summary> userAssignedIdentity. </summary>
        public static LinkerAuthType UserAssignedIdentity { get; } = new LinkerAuthType(UserAssignedIdentityValue);
        /// <summary> servicePrincipalSecret. </summary>
        public static LinkerAuthType ServicePrincipalSecret { get; } = new LinkerAuthType(ServicePrincipalSecretValue);
        /// <summary> servicePrincipalCertificate. </summary>
        public static LinkerAuthType ServicePrincipalCertificate { get; } = new LinkerAuthType(ServicePrincipalCertificateValue);
        /// <summary> secret. </summary>
        public static LinkerAuthType Secret { get; } = new LinkerAuthType(SecretValue);
        /// <summary> Determines if two <see cref="LinkerAuthType"/> values are the same. </summary>
        public static bool operator ==(LinkerAuthType left, LinkerAuthType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LinkerAuthType"/> values are not the same. </summary>
        public static bool operator !=(LinkerAuthType left, LinkerAuthType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LinkerAuthType"/>. </summary>
        public static implicit operator LinkerAuthType(string value) => new LinkerAuthType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LinkerAuthType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LinkerAuthType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
