// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The secret info when type is keyVaultSecretReference. It's for scenario that user provides a secret stored in user's keyvault and source is Azure Kubernetes. The key Vault's resource id is linked to secretStore.keyVaultId. </summary>
    public partial class KeyVaultSecretReferenceSecretInfo : SecretBaseInfo
    {
        /// <summary> Initializes a new instance of <see cref="KeyVaultSecretReferenceSecretInfo"/>. </summary>
        public KeyVaultSecretReferenceSecretInfo()
        {
            SecretType = LinkerSecretType.KeyVaultSecretReference;
        }

        /// <summary> Initializes a new instance of <see cref="KeyVaultSecretReferenceSecretInfo"/>. </summary>
        /// <param name="secretType"> The secret type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Name of the Key Vault secret. </param>
        /// <param name="version"> Version of the Key Vault secret. </param>
        internal KeyVaultSecretReferenceSecretInfo(LinkerSecretType secretType, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, string version) : base(secretType, serializedAdditionalRawData)
        {
            Name = name;
            Version = version;
            SecretType = secretType;
        }

        /// <summary> Name of the Key Vault secret. </summary>
        public string Name { get; set; }
        /// <summary> Version of the Key Vault secret. </summary>
        public string Version { get; set; }
    }
}
