// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ServiceLinker.Models
{
    /// <summary> The resource properties when type is Azure Key Vault. </summary>
    public partial class AzureKeyVaultProperties : AzureResourceBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AzureKeyVaultProperties"/>. </summary>
        public AzureKeyVaultProperties()
        {
            AzureResourceType = AzureResourceType.KeyVault;
        }

        /// <summary> Initializes a new instance of <see cref="AzureKeyVaultProperties"/>. </summary>
        /// <param name="azureResourceType"> The azure resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="doesConnectAsKubernetesCsiDriver"> True if connect via Kubernetes CSI Driver. </param>
        internal AzureKeyVaultProperties(AzureResourceType azureResourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, bool? doesConnectAsKubernetesCsiDriver) : base(azureResourceType, serializedAdditionalRawData)
        {
            DoesConnectAsKubernetesCsiDriver = doesConnectAsKubernetesCsiDriver;
            AzureResourceType = azureResourceType;
        }

        /// <summary> True if connect via Kubernetes CSI Driver. </summary>
        public bool? DoesConnectAsKubernetesCsiDriver { get; set; }
    }
}
