// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.ServiceLinker.Models;

namespace Azure.ResourceManager.ServiceLinker
{
    internal class LinkerValidateOperationResultOperationSource : IOperationSource<LinkerValidateOperationResult>
    {
        LinkerValidateOperationResult IOperationSource<LinkerValidateOperationResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return LinkerValidateOperationResult.DeserializeLinkerValidateOperationResult(document.RootElement);
        }

        async ValueTask<LinkerValidateOperationResult> IOperationSource<LinkerValidateOperationResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return LinkerValidateOperationResult.DeserializeLinkerValidateOperationResult(document.RootElement);
        }
    }
}
